<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class GiftsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('gift');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function ifExist(string $title): array
	{
		$record = $this->find()
			->where(['title' => $title])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getAllAgainstType(string $type): array
	{
		return $this->find()
			->where(['type' => $type])
			->all()
			->toList();
	}

	public function getAll(): array
	{
		return $this->find()
			->orderDesc('featured')
			->all()
			->toList();
	}
}
