<?php
declare(strict_types=1);
require __DIR__ . '/constant.php';
use Cake\Core\Configure;
use Cake\Cache\Cache;
use Cake\Cache\Engine\FileEngine;
use Cake\Cache\Engine\RedisEngine;
Configure::write('debug', (bool)getenv('DEBUG'));
Configure::write('Error', [
	'errorLevel' => E_ALL & ~E_DEPRECATED,
	'exceptionRenderer' => \Cake\Error\ExceptionRenderer::class,
	'skipLog' => [],
	'log' => true
]);
Configure::write('App.encoding', 'UTF-8');
Configure::write('App.defaultLocale', 'en_US');
Configure::write('Security.salt', 'DYhG93b0qyJfIxfs2guVsoUubWwvniR2G0FgaC9mi');
Configure::write('Acl.classname', 'DbAcl');
$engine = FileEngine::class;
$duration = Configure::read('debug') ? '+10 seconds' : '+999 days';
$prefix = 'myapp_';
Cache::setConfig('_cake_core_', [
	'className' => $engine,
	'prefix'    => $prefix . 'cake_core_',
	'path'      => CACHE . 'persistent' . DIRECTORY_SEPARATOR,
	'serialize' => true,
	'duration'  => $duration
]);
Cache::setConfig('_cake_model_', [
	'className' => $engine,
	'prefix'    => $prefix . 'cake_model_',
	'path'      => CACHE . 'models' . DIRECTORY_SEPARATOR,
	'serialize' => true,
	'duration'  => $duration
]);
Cache::setConfig('default1', [
	'className' => RedisEngine::class,
	'duration'  => '+1 hour',
	'prefix'    => 'cake_',
	'url'       => sprintf('redis://:%s@%s:6379', REDIS_PASSWORD, REDIS_HOST),
	'timeout'   => 0.0,
	'persistent'=> false
]);
