<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class LiveStreamingsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('live_streaming');
		$this->setPrimaryKey('id');

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'joinType' => 'INNER',
			'className' => 'App\Model\Table\UsersTable',
		]);
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getLastLiveStreaming(int $user_id): array
	{
		$record = $this->find()
			->where(['user_id' => $user_id])
			->order(['id' => 'DESC'])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getAllPages(): array
	{
		return $this->find()
			->order(['id' => 'DESC'])
			->toArray();
	}

	public function countCoinsEarnedByUser(int $user_id): int
	{
		$result = $this->find()
			->select([
				'total_amount' => $this->find()->func()->sum('earn_coin')
			])
			->where(['user_id' => $user_id])
			->first();

		return (int)($result?->get('total_amount') ?? 0);
	}
}
