<?php
declare(strict_types=1);
namespace Stripe\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Event\EventInterface;
use Cake\Datasource\EntityInterface;
use ArrayObject;

class StripePlansTable extends Table {
	public string $path = '/plans';
	protected array $_schema = [
		'id' => ['type' => 'string', 'length' => 45],
		'amount' => ['type' => 'integer'],
		'currency' => ['type' => 'string', 'length' => 3],
		'interval' => ['type' => 'string', 'length' => 5],
		'name' => ['type' => 'string'],
		'trial_period_days' => ['type' => 'integer']
	];

	public function initialize(array $config): void {
		parent::initialize($config);
		$this->setTable('stripe_plans');
		$this->setPrimaryKey('id');
	}

	public function validationDefault(Validator $validator): Validator {
		$validator
			->notEmptyString('id', 'Please enter an id.')
			->notEmptyString('amount', 'Please enter an amount.')
			->numeric('amount', 'Amount must be a number.')
			->notEmptyString('currency', 'Please enter a currency type.')
			->inList('currency', ['usd'], 'Please enter a valid currency code.')
			->notEmptyString('interval', 'Please enter a billing interval.')
			->inList('interval', ['month', 'year'], 'Please enter a valid billing interval.')
			->notEmptyString('name', 'Please enter an name.')
			->notEmptyString('trial_period_days', 'Please enter an trial period.')
			->numeric('trial_period_days', 'Trial period must be an amount of days.');
		return $validator;
	}

	public function beforeSave(EventInterface $event, EntityInterface $entity, ArrayObject $options) {
		$entity->id = null;
		return true;
	}
}
