<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class SettingsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('setting');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['Setting.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getDetailsAgainstType(string $type): array
	{
		$result = $this->find()
			->where(['Setting.type' => $type])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function checkDuplicate(string $type): array
	{
		$result = $this->find()
			->where(['Setting.type' => $type])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}
}
?>
