<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;
use Cake\Datasource\EntityInterface;

class VideoWatchesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('video_watch');
		$this->setPrimaryKey('id');

		$this->belongsTo('Devices', [
			'foreignKey' => 'device_id',
		]);

		$this->belongsTo('Videos', [
			'foreignKey' => 'video_id',
		]);
	}

	public function getDetails(int $id): ?array
	{
		return $this->find()
			->where(['VideoWatch.id' => $id])
			->enableHydration(false)
			->first() ?? [];
	}

	public function countWatchVideosTotal(int $video_id): int
	{
		return $this->find()
			->where(['VideoWatch.video_id' => $video_id])
			->count();
	}

	public function countWatchVideos(array $video_ids, string $start_datetime, string $end_datetime): int
	{
		return $this->find()
			->where([
				'VideoWatch.video_id IN' => $video_ids,
				'VideoWatch.created >=' => $start_datetime,
				'VideoWatch.created <=' => $end_datetime
			])
			->count();
	}

	public function countWatchVideosByDate(array $video_ids, string $start_datetime, string $end_datetime): array
	{
		return $this->find()
			->select([
				'date' => 'DATE(VideoWatch.created)',
				'count' => $this->find()->func()->count('*')
			])
			->where([
				'VideoWatch.video_id IN' => $video_ids,
				'VideoWatch.created >=' => $start_datetime,
				'VideoWatch.created <=' => $end_datetime
			])
			->group('DATE(VideoWatch.created)')
			->orderAsc('DATE(VideoWatch.created)')
			->enableHydration(false)
			->all()
			->toList();
	}

	public function ifExist(array $data): ?array
	{
		return $this->find()
			->where([
				'VideoWatch.video_id' => $data['video_id'],
				'VideoWatch.device_id' => $data['device_id']
			])
			->enableHydration(false)
			->first() ?? [];
	}

	public function getAll(): array
	{
		return $this->find()
			->enableHydration(false)
			->all()
			->toList();
	}
}
