<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PaymentCardsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('payment_card');
		$this->setPrimaryKey('id');
	}

	public function isUserStripeCustIDExist(int $user_id): int
	{
		return $this->find()
			->where([
				'PaymentCard.user_id' => $user_id,
				'PaymentCard.stripe IS NOT' => null,
				'PaymentCard.stripe !=' => ''
			])
			->count();
	}

	public function getUserCards(int $user_id): array
	{
		return $this->find()
			->select(['stripe', 'id'])
			->where(['PaymentCard.user_id' => $user_id])
			->toArray();
	}
}
