<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Datasource\EntityInterface;
use Cake\ORM\Query;

class LocationsTable extends Table
{
	public function getDetails(int $id): array
	{
		$location = $this->find()
			->where(['id' => $id])
			->first();

		return $location ? $location->toArray() : [];
	}

	public function ifPlaceIDExist(string $place_id): array
	{
		$location = $this->find()
			->where(['google_place_id' => $place_id])
			->first();

		return $location ? $location->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()->all()->toList();
	}
}
