<?php

declare(strict_types=1);

use PHPUnit\Framework\TestSuite;

class AllTestsTest extends TestSuite
{
	public static function suite(): self
	{
		$suite = new self('All Tests');
		$suite->addTestFiles(self::getTestFiles(Cake\Core\Plugin::path('Stripe') . 'tests' . DIRECTORY_SEPARATOR . 'TestCase' . DIRECTORY_SEPARATOR));
		return $suite;
	}

	protected static function getTestFiles(string $directory): array
	{
		$files = [];
		$iterator = new RecursiveIteratorIterator(
			new RecursiveDirectoryIterator($directory)
		);
		foreach ($iterator as $file) {
			if ($file->isFile() && preg_match('/Test\.php$/', $file->getFilename())) {
				$files[] = $file->getPathname();
			}
		}
		return $files;
	}
}
