<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class CoinWorthsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('coin_worth');
	}

	public function getDetails(int $id): ?array
	{
		$record = $this->find()
			->where(['CoinWorth.id' => $id])
			->first();

		return $record?->toArray();
	}

	public function getAll(): ?array
	{
		$record = $this->find()->first();
		return $record?->toArray();
	}
}
