<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;

class BusinessesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('business');
		$this->belongsTo('User', [
			'className' => 'Users',
			'foreignKey' => 'user_id',
		]);
	}

	public function getDetails(int $id): array
	{
		$entity = $this->find()
			->where(['Business.id' => $id])
			->first();
		return $entity !== null ? $entity->toArray() : [];
	}

	public function checkBusinessExistAgainstUserID(int $user_id, string $verification_type): array
	{
		$entity = $this->find()
			->where([
				'Business.user_id' => $user_id,
				'Business.verification_type' => $verification_type,
			])
			->first();
		return $entity !== null ? $entity->toArray() : [];
	}

	public function getAll(): array
	{
		$results = $this->find()
			->contain(['User'])
			->where(['User.id >' => 0])
			->toArray();
		return $results;
	}
}
