<?php

namespace App\Lib;

use Aws\S3\S3Client;
use Aws\MediaConvert\MediaConvertClient;
use Aws\Exception\AwsException;
use Aws\S3\Exception\S3Exception;
use App\Lib\Ffmpeg;
use App\Lib\Utility;

class Message
{
    public static function DATAALREADYEXIST(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'email already exist']);
    }

    public static function DATASUCCESSFULLYSAVED(): void
    {
        echo json_encode(['code' => 200, 'msg' => 'successfully saved data into db']);
    }

    public static function DATASUCCESSFULLYUPDATED(): void
    {
        echo json_encode(['code' => 200, 'msg' => 'successfully updated data into db']);
    }

    public static function UNAUTHORIZED(): void
    {
        echo json_encode(['code' => 401, 'msg' => 'unauthorized']);
    }

    public static function INVALIDPARAMTERS(): void
    {
        echo json_encode([
            'code' => 400,
            'msg' => 'Bad Request: The JSON format is incorrect or the parameters passed are invalid.'
        ]);
    }

    public static function DATASAVEERROR(): void
    {
        echo json_encode(['code' => 400, 'msg' => 'Something really went wrong in saving the data into Database']);
    }

    public static function ERROR(): void
    {
        echo json_encode(['code' => 401, 'msg' => 'error']);
    }

    public static function DATAFETCHINGERROR(): void
    {
        echo json_encode(['code' => 400, 'msg' => 'Something really went wrong in fetching the data into Database']);
    }

    public static function EMAILSENDINGERROR(): void
    {
        echo json_encode(['code' => 400, 'msg' => 'Something really went wrong in sending the email']);
    }

    public static function INVALIDDETAILS(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'Incorrect login details']);
    }

    public static function DUPLICATEDATE(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'Data Already exist']);
    }

    public static function NOCHANGES(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'NO Changes in the data']);
    }

    public static function INCORRECTPASSWORD(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'Incorrect old password']);
    }

    public static function EmptyDATA(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'EMPTY: NO RECORD IN THE DATABASE']);
    }

    public static function DONOTEXIST(string $object): void
    {
        echo json_encode(['code' => 404, 'msg' => "Not Found: The requested resource($object) does not exist."]);
    }

    public static function METHODNOTALLOWED(): void
    {
        echo json_encode([
            'code' => 405,
            'msg' => 'The requested method is not supported for this endpoint. Please use a POST request.'
        ]);
    }

    public static function STRIPIDEMPTY(): void
    {
        echo json_encode(['code' => 202, 'msg' => 'payment is not added by student']);
    }

    public static function DELETEDSUCCESSFULLY(): void
    {
        echo json_encode(['code' => 200, 'msg' => 'Deleted Successfully']);
    }

    public static function ALREADYDELETED(): void
    {
        echo json_encode(['code' => 201, 'msg' => 'Already deleted']);
    }

    public static function ACCESSRESTRICTED(): void
    {
        echo json_encode(['code' => 202, 'msg' => 'Access Restricted']);
    }

    public static function EDITRESTRICTED(): void
    {
        echo json_encode(['code' => 202, 'msg' => 'You cannot edit this. Please contact the administrator']);
    }

    public static function DELETERESTRICTED(): void
    {
        echo json_encode(['code' => 202, 'msg' => 'You cannot delete this. Please contact the administrator']);
    }
}
?>
