<?php

namespace App\Lib;

use Aws\S3\S3Client;
use Aws\MediaConvert\MediaConvertClient;
use Aws\Exception\AwsException;
use Aws\S3\Exception\S3Exception;
use App\Lib\Ffmpeg;
use App\Lib\Utility;

class CustomEmail
{
    public static function sendMail(array $data): ?array
    {
        $to_email = $data['to'];

        $email_form = [
            'From' => SUPPORT_EMAIL,
            'To' => $to_email,
            'Subject' => $data['subject'],
            'HtmlBody' => $data['message'],
            'TextBody' => $data['message'],
            'ReplyTo' => SUPPORT_EMAIL
        ];

        $json = json_encode($email_form);
        $ch = curl_init('https://api.postmarkapp.com/email');
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
                'Content-Type: application/json',
                'X-Postmark-Server-Token: ' . POSTMARK_SERVER_API_TOKEN
            ],
            CURLOPT_POSTFIELDS => $json
        ]);

        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        return $response;
    }
}

?>
